import json
import sys
sys.path.insert(0, '/var/www/cgi-bin')
import logging_rpi
sys.path.insert(0, '/home/pi/Pulsar')
from InternalQueueListener import InternalQueueListener
import os
import websocket
import base64
import io
import subprocess
import sqlite3


class ConfigurationModule(InternalQueueListener):

    def __init__(self, internalQueue, module):
        InternalQueueListener.__init__(self, internalQueue, module)
        self.configDirectory = "/home/pi/config/conf-enabled/"
        self.scriptDirectory = "/home/pi/config/func/"

    def runConfig(self, pythonScript, data):
        sys.argv = [pythonScript, data]
        execfile(pythonScript)

    def main(self):

        try:
            print "Configuration Module has retrieved a piece of data for itself."
            
            module = self.data['ConfigurationModule']
            configFile = self.configDirectory + module + ".conf"
            pythonScript =  self.scriptDirectory + module + ".py"

            #if both script and config exists
            if os.path.exists(configFile) and os.path.exists(pythonScript):
                with open(configFile, "r") as f:
                    jsonData = f.read()
                    jsonData = json.loads(jsonData)
                    if jsonData['Subscribe']:
                        logging_rpi.log.info("ConfigurationModule:::Update Enabled:::Running {0}.".format(pythonScript))
                        self.runConfig(pythonScript, self.data)
                    else:
                        logging_rpi.log.info("ConfigurationModule:::Update Disabled:::Flag to update disabled: {0}.".format(pythonScript))
            elif os.path.exists(pythonScript):
                logging_rpi.log.info("ConfigurationModule:::No Config File:::No Configuration file found. Running script with data provided.")
                self.runConfig(pythonScript, self.data)
            else:
                logging_rpi.log.error("ConfigurationModule:::No Configuration Script::: {0} not found.".format(pythonScript))

            return True
        except Exception as e:
            logging_rpi.log.error("ConfigurationModule:::Except Occured in Main:::" + str(e))
            return True

if __name__ == '__main__':

    try:
        configModule = ConfigurationModule("privateQueue", "configurationmodule")
        configModule.listen()
    except KeyboardInterrupt as e:
        print "\nStopped Listening to privateQueue. Exiting..."

        